package gov.va.med.mhv.usermgmt.integration.service.delegate;

import gov.va.med.mhv.integration.registry.transfer.Patient;
import gov.va.med.mhv.integration.registry.transfer.Status;

/**
 * Service delegate for the Patient service
 */
public interface PatientCorrelationServiceDelegate {

    // N.B. - This MUST be namespaced to ensure uniqueness when multiple 
    // apps are present
    /** 
     * Name which uniquely identifies the PatientIdentity service. 
     **/
    public static final String SERVICE_NAME = 
        "gov.va.med.mhv.integration.registry.PatientCorrelationService";

    public Status correlatePatient(Patient patient);
    
    public Status uncorrelatePatient(Patient patient);
    
}